# EUROSTAR × MALTEPE UNIVERSITY
## Official International Master & Residence Platform

---

## 🎯 Project Overview

**Name:** EUROSTAR × MALTEPE UNIVERSITY Platform  
**Type:** High-conversion multilingual university website + Master application portal  
**Partner:** Maltepe University (Istanbul, Turkey)  
**Representative:** EUROSTAR International Education

### Mission
Provide a professional, trustworthy platform for foreign nationals whose Turkish residence permit is expiring, offering a **legal solution through Master's education**.

### Core Message
> "Study 2–3 days a week. Stay legally in Turkey. Work, live, and earn in Istanbul."

---

## 🌐 Live URLs

### Development
- **Sandbox URL:** https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai
- **Local Dev:** http://localhost:3000

### API Endpoints
- `GET /api/programs` - List all Master's programs (with filtering)
- `POST /api/applications` - Submit free application

### Language Support
Access any page with `?lang=` parameter:
- English: `?lang=en` (default)
- Turkmen: `?lang=tk`
- Persian: `?lang=fa`
- French: `?lang=fr`
- Azerbaijani: `?lang=az`
- Kazakh: `?lang=kz`
- Indonesian: `?lang=id`

**Example:** https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=fa

---

## ✨ Completed Features

### 🎨 Visual Design (NEW v1.2.0)
- ✅ **Stunning Background Images**: Istanbul Bosphorus, Galata Tower, City Skyline
- ✅ **Campus Backgrounds**: Modern Maltepe University campus with green spaces
- ✅ **Professional Photography**: High-quality images from Pexels
- ✅ **Gradient Overlays**: Perfect balance of imagery and text readability
- ✅ **Mobile Responsive**: All backgrounds adapt to any screen size
- ✅ **Cultural Context**: Real Istanbul landmarks create emotional connection

### 🏠 Homepage
- ✅ Hero section with compelling headline + **Istanbul Bosphorus background**
- ✅ Key benefits cards (Residence Permit, Flexible Schedule, Work Opportunity, EU Diploma)
- ✅ **NEW: Program Slider** - Interactive carousel with 12 featured programs (Slick Carousel)
- ✅ **NEW: Quick Application Form** - 2-minute application with passport/diploma upload
- ✅ Quick links to all sections
- ✅ Call-to-action buttons
- ✅ WhatsApp floating button (visible on all pages)

### 📚 Content Pages
- ✅ **Why Master in Turkey?** - Legal stay explanation, residence types comparison
- ✅ **About Maltepe University** - Campus facilities, international environment, accreditation
- ✅ **Master's Programs** - 55+ programs with dynamic filtering by category
- ✅ **Study + Work Model** - Weekly schedule explanation with legal disclaimer
- ✅ **Living in Istanbul - Maltepe** - Monthly cost breakdown
- ✅ **Residence Permit Process** - 6-step timeline with clear guidance
- ✅ **Contact Page** - Office address, phone, WhatsApp, email, office hours, map

### 📝 Application System
- ✅ **Quick Application (Homepage)** - Passport, Diploma, Phone, Program selection
- ✅ **Full Application (/apply)** - Complete form with residence and education details
- ✅ Free application (no fees)
- ✅ Personal information collection
- ✅ Current residence status tracking
- ✅ Education background assessment
- ✅ Program preference selection
- ✅ Direct submission to D1 database
- ✅ **Email routing to yazardefteri@gmail.com**
- ✅ Success confirmation messages
- ✅ Form validation and error handling

### 🗣️ Multilingual Support
- ✅ 7 languages fully implemented
- ✅ Persistent language selector in navigation
- ✅ URL-based language switching
- ✅ Native-level translations for all content

### 🎨 Design & UX
- ✅ Corporate, academic, trustworthy style
- ✅ Deep blue, white, soft gold color scheme
- ✅ Clean sections with icon-supported explanations
- ✅ Mobile-first responsive design
- ✅ Fast loading with CDN libraries

### 🔒 Trust & Legal Compliance
- ✅ "Official EUROSTAR Representative" branding
- ✅ Clear legal disclaimers on work permits
- ✅ Transparent academic criteria
- ✅ No illegal work promises
- ✅ No exaggerated salary claims

---

## 📊 Data Architecture

### Database: Cloudflare D1 (SQLite)
**Total Programs:** 55 Master's programs

#### Programs Table
```sql
- id: Program ID
- name_en: English program name
- name_tr: Turkish program name
- category: Program category (Engineering, Business, Law, etc.)
- field: Field of study
- language: Instruction language (TURKISH/ENGLISH)
- thesis_type: 'thesis' or 'non-thesis'
- tuition_fee: Annual tuition (USD)
- advance_payment: Initial payment (USD)
- study_period: Duration (2 years)
- attendance: Schedule (2-3 days per week)
```

#### Applications Table
```sql
- id: Application ID
- full_name, email, phone, nationality
- current_residence_status, residence_expiry_date
- education_level, bachelor_university, bachelor_field
- program_interest, language_preference
- message: Additional notes
- status: pending/reviewed/accepted/rejected
- created_at, updated_at
```

#### Program Categories
1. **Engineering** (8 programs) - Computer, Industrial, Electrical, Civil, Mathematics
2. **Architecture & Design** (9 programs) - Architecture, Interior, Structural, Restoration
3. **Business** (8 programs) - Business Admin, e-Business, Logistics, International Trade
4. **Law** (5 programs) - Public Law, Private Law, Human Rights, Tech & IP Law
5. **Education** (4 programs) - Educational Admin, English Language, Preschool
6. **Psychology** (2 programs) - Guidance & Psychological Counseling
7. **Media & Communication** (5 programs) - Radio/TV/Cinema, Marketing Communication, Film Design
8. **Social Sciences** (3 programs) - Philosophy, Sociology, Philosophical Counseling
9. **Political Science** (2 programs) - Political Science & International Relations
10. **Arts** (2 programs) - Arts Policy & Management, Music

### Storage Services
- **D1 Database:** Program listings, application data
- **R2 Bucket (configured):** For future document uploads
- **KV Storage (optional):** For caching and configuration

---

## 🚀 Deployment Guide

### Local Development

```bash
# 1. Install dependencies (already done)
npm install

# 2. Initialize D1 database locally
npm run db:migrate:local
npx wrangler d1 execute webapp-production --local --file=./seed.sql

# 3. Build the project
npm run build

# 4. Start development server with PM2
pm2 start ecosystem.config.cjs

# 5. Test the application
curl http://localhost:3000
```

### Production Deployment to Cloudflare Pages

#### Prerequisites
- Cloudflare account
- Cloudflare API token configured
- GitHub repository (optional)

#### Step 1: Setup Cloudflare API
```bash
# Configure Cloudflare authentication
# Use setup_cloudflare_api_key tool or manually set CLOUDFLARE_API_TOKEN
```

#### Step 2: Create Production D1 Database
```bash
# Create production database
npx wrangler d1 create webapp-production

# Copy the database_id from output and update wrangler.jsonc
# Update the database_id in wrangler.jsonc

# Apply migrations to production
npm run db:migrate:prod

# Seed production database
npx wrangler d1 execute webapp-production --file=./seed.sql
```

#### Step 3: Create R2 Bucket (Optional for Document Uploads)
```bash
npx wrangler r2 bucket create webapp-documents
```

#### Step 4: Deploy to Cloudflare Pages
```bash
# Build the project
npm run build

# Deploy to Cloudflare Pages
npm run deploy:prod

# You'll receive URLs like:
# - Production: https://webapp.pages.dev
# - Branch: https://main.webapp.pages.dev
```

#### Step 5: Configure Environment Variables (Optional)
```bash
# Add any secrets/environment variables
npx wrangler pages secret put API_KEY --project-name webapp
```

---

## 🛠️ Technical Stack

### Backend
- **Hono** v4.11.9 - Lightweight web framework
- **Cloudflare Workers** - Edge runtime
- **TypeScript** - Type-safe development

### Database & Storage
- **Cloudflare D1** - SQLite database (55 programs)
- **Cloudflare R2** - Object storage (configured)

### Frontend
- **Tailwind CSS** (CDN) - Utility-first styling
- **Font Awesome** (CDN) - Icons
- **Vanilla JavaScript** - Interactive features
- **Server-Side Rendering** - Hono JSX

### Development Tools
- **Vite** - Build tool
- **Wrangler** - Cloudflare CLI
- **PM2** - Process manager (sandbox only)
- **Git** - Version control

---

## 📁 Project Structure

```
webapp/
├── src/
│   ├── index.tsx           # Main Hono application with all routes
│   ├── renderer.tsx        # Layout with navigation & footer
│   └── translations.ts     # 7-language translation system
├── public/static/
│   ├── style.css           # Comprehensive CSS styles
│   ├── programs.js         # Program filtering & display
│   └── application.js      # Application form handler
├── migrations/
│   └── 0001_initial_schema.sql  # Database schema
├── seed.sql                # 55 programs seed data
├── programs_data.json      # Extracted program data
├── ecosystem.config.cjs    # PM2 configuration
├── wrangler.jsonc          # Cloudflare configuration
├── package.json            # Dependencies & scripts
└── README.md               # This file
```

---

## 🌟 Key Features Implementation

### 1. Multilingual Architecture
- URL-based language switching (`?lang=en`)
- Translations for 7 languages
- Persistent language selector
- Right-to-left support for Persian

### 2. Program Filtering System
- Dynamic category filters
- Real-time filtering
- 55+ programs from Excel data
- Thesis/Non-thesis distinction
- Tuition fee display

### 3. Application Flow
- Free application (no fees)
- Comprehensive form validation
- Direct D1 database insertion
- Email confirmation (ready for integration)
- Status tracking system

### 4. Legal Compliance
- Clear residence permit process
- Transparent cost breakdown
- Work permit disclaimers
- No illegal promises
- Official branding

### 5. Conversion Optimization
- Hero CTA on every page
- Sticky "Apply Now" option
- Multiple entry points to application
- Clear value propositions
- Trust signals throughout

---

## 🔧 Available NPM Scripts

```bash
# Development
npm run dev               # Vite dev server
npm run dev:sandbox       # Wrangler dev with D1 (port 3000)
npm run build             # Build for production

# Database (D1)
npm run db:migrate:local  # Apply migrations locally
npm run db:migrate:prod   # Apply migrations to production
npm run db:console:local  # Open local D1 console
npm run db:console:prod   # Open production D1 console

# Deployment
npm run deploy            # Build + deploy to Cloudflare
npm run deploy:prod       # Build + deploy with project name

# Utilities
npm run clean-port        # Kill process on port 3000
npm run test              # Test local server
npm run cf-typegen        # Generate Cloudflare types

# Git
npm run git:status        # Check git status
npm run git:log           # View commit history
npm run git:commit "msg"  # Quick commit
```

---

## 📋 Page URIs

| Page | URI | Parameters |
|------|-----|------------|
| Homepage | `/` | `?lang=en/tk/fa/fr/az/kz/id` |
| Why Turkey | `/why-turkey` | `?lang=...` |
| About Maltepe | `/maltepe` | `?lang=...` |
| Programs | `/programs` | `?lang=...` |
| Living Costs | `/living` | `?lang=...` |
| Residence Process | `/residence` | `?lang=...` |
| Contact | `/contact` | `?lang=...` |
| Application Form | `/apply` | `?lang=...` |
| API: Programs | `/api/programs` | `?category=&language=&thesis_type=` |
| API: Applications | `/api/applications` | POST only |

---

## ⚠️ Features NOT Yet Implemented

### Document Upload System
- R2 bucket is configured but not integrated
- Application form doesn't support file uploads yet
- **Next Step:** Add file upload field + R2 integration

### Email Notifications
- Application confirmations not automated
- **Next Step:** Integrate email service (SendGrid, etc.)

### Admin Dashboard
- No admin panel to review applications
- **Next Step:** Create protected admin routes

### Advanced Filtering
- Programs page filters by category only
- **Next Step:** Add language, tuition range, thesis type filters

### Payment Integration
- No online payment system
- **Next Step:** Integrate Stripe or Turkish payment gateway

### WhatsApp Integration
- No WhatsApp contact button
- **Next Step:** Add WhatsApp Business API integration

---

## 📈 Recommended Next Steps

### Phase 1: Core Enhancements (High Priority)
1. **Add R2 Document Upload** to application form
2. **Email Notification System** for application confirmations
3. **Admin Dashboard** for application management
4. **WhatsApp Contact Button** for instant support

### Phase 2: Marketing & SEO (Medium Priority)
5. **SEO Optimization** - meta tags, structured data, sitemap
6. **Google Analytics** integration
7. **Social Media Integration** - share buttons, Open Graph tags
8. **Blog Section** for content marketing

### Phase 3: Advanced Features (Low Priority)
9. **Student Portal** for accepted students
10. **Payment Gateway** integration
11. **Live Chat Support**
12. **Mobile App** (React Native)

---

## 🔒 Security & Privacy

### Data Protection
- SSL/TLS encryption (Cloudflare)
- Secure database (D1 with Cloudflare security)
- No sensitive data in frontend
- Privacy-compliant form handling

### Legal Compliance
- GDPR considerations implemented
- Clear data usage policies
- Transparent application process
- No deceptive marketing claims

---

## 📞 Contact & Support

**EUROSTAR International Education**  
📍 İstiklal Street No:49/5, Taksim, İstanbul, Turkey  
📞 0212 244 66 00  
📱 WhatsApp: 0543 344 58 87  
📧 info@eurostar-education.com

**Office Hours:**  
Monday - Friday: 9:00 - 18:00  
Saturday: 10:00 - 15:00  
Sunday: Closed

**Technical Support:**  
For technical issues or deployment questions, contact the development team.

---

## 📝 Changelog

### Version 1.1.0 (2026-02-10)
- ✅ Added Contact page with office information
- ✅ Integrated WhatsApp floating button
- ✅ Updated contact information (phone, WhatsApp, address)
- ✅ Added Google Maps integration
- ✅ Enhanced footer with clickable contact links

### Version 1.0.0 (2026-02-10)
- ✅ Initial release
- ✅ 7-language support
- ✅ 55 Master's programs
- ✅ Complete application system
- ✅ D1 database integration
- ✅ Cloudflare Pages deployment ready
- ✅ Mobile-responsive design
- ✅ Legal compliance framework

---

## 📄 License

© 2026 EUROSTAR International Education. All rights reserved.

This platform is the official representative portal for Maltepe University international admissions. All program information is accurate as of publication date. EUROSTAR and Maltepe University reserve the right to modify programs and requirements.

---

## 🙏 Acknowledgments

- **Maltepe University** - Program data and partnership
- **Cloudflare** - Edge infrastructure and D1 database
- **Hono Framework** - Lightweight web framework
- **Tailwind CSS** - Utility-first styling

---

**Last Updated:** 2026-02-10  
**Status:** ✅ Production Ready  
**Deployment:** Sandbox Active | Production Pending

---

## 📧 Email Notification System

**Email Routing:** All application forms send notifications to **yazardefteri@gmail.com**

### Quick Application Form (Homepage)
- ✅ Collects: Name, Phone, Email, Program, Passport, Diploma
- ✅ 2-minute submission
- ✅ Email notification with bilingual content (Turkish/English)
- ✅ Saved to database

### Full Application Form (/apply)
- ✅ Complete residence and education details
- ✅ Comprehensive email notification
- ✅ All data saved to D1 database

**Current Status:** Email notifications are logged to console (development mode)  
**For Production:** Integrate Resend, SendGrid, or Mailgun  
**Documentation:** See `EMAIL_SYSTEM.md` for complete integration guide

**Test Endpoint:**
```bash
curl -X POST http://localhost:3000/api/quick-application \
  -H "Content-Type: application/json" \
  -d '{
    "fullName": "Test User",
    "phone": "+90 555 111 22 33",
    "email": "test@example.com",
    "program": "Computer Engineering Master Program",
    "passportFileName": "passport.pdf",
    "diplomaFileName": "diploma.pdf"
  }'
```

---

## 🎨 Homepage Features

### Program Slider
- **Technology:** Slick Carousel with jQuery
- **Display:** 12 featured programs in interactive carousel
- **Features:**
  - Auto-play with 3-second interval
  - Responsive (3 slides on desktop, 2 on tablet, 1 on mobile)
  - Program cards show: Category, Name, Language, Duration, Thesis Type, Tuition Fee
  - "Apply Now" button on each card
  - Navigation dots and arrows

### Quick Application Form
- **Location:** Homepage below program slider
- **Purpose:** Fast 2-minute application
- **Fields:**
  - Full Name (required)
  - Phone Number (required)
  - Email (required)
  - Program Selection (dropdown with 55+ programs, required)
  - Passport Copy Upload (PDF/JPG/PNG, required)
  - Diploma Copy Upload (PDF/JPG/PNG, required)
- **User Experience:**
  - Form validation
  - Loading state during submission
  - Success message with email confirmation
  - Auto-reset after submission
  - Error handling with contact info fallback

---

## 📱 Contact Information

**Office Address:**  
İstiklal Street No:49/5  
Taksim, İstanbul, Turkey

**Phone:** 0212 244 66 00  
**WhatsApp:** 0543 344 58 87  
**Email Routing:** yazardefteri@gmail.com (for applications)

**WhatsApp Integration:**
- ✅ Floating button on all pages (bottom-right corner)
- ✅ Green color (#25D366) with pulse animation
- ✅ Direct link: https://wa.me/905433445887
- ✅ Mobile responsive

---
