# EUROSTAR × MALTEPE UNIVERSITY - Testing URLs

## 🌐 Base URL
**Sandbox:** https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai

---

## 📄 All Pages - English

| Page | URL |
|------|-----|
| Homepage | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=en |
| Why Turkey | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/why-turkey?lang=en |
| About Maltepe | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/maltepe?lang=en |
| Programs | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/programs?lang=en |
| Living Costs | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/living?lang=en |
| Residence Process | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/residence?lang=en |
| Application Form | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/apply?lang=en |

---

## 🗣️ Multilingual Demos

### Homepage in All 7 Languages

| Language | URL |
|----------|-----|
| 🇬🇧 English | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=en |
| 🇹🇲 Turkmen | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=tk |
| 🇮🇷 Persian | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=fa |
| 🇫🇷 French | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=fr |
| 🇦🇿 Azerbaijani | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=az |
| 🇰🇿 Kazakh | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=kz |
| 🇮🇩 Indonesian | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/?lang=id |

### Application Form in Different Languages

| Language | URL |
|----------|-----|
| Turkmen | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/apply?lang=tk |
| Persian | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/apply?lang=fa |
| French | https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/apply?lang=fr |

---

## 🔌 API Endpoints

### Get All Programs
```bash
curl https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/api/programs
```

### Filter by Category
```bash
# Engineering programs
curl https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/api/programs?category=Engineering

# Business programs
curl https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/api/programs?category=Business
```

### Filter by Language
```bash
# English programs
curl https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/api/programs?language=ENGLISH

# Turkish programs
curl https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/api/programs?language=TURKISH
```

### Submit Application
```bash
curl -X POST https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/api/applications \
  -H "Content-Type: application/json" \
  -d '{
    "fullName": "Test User",
    "email": "test@example.com",
    "nationality": "Turkmenistan",
    "residenceStatus": "tourist",
    "educationLevel": "bachelor",
    "programInterest": "engineering",
    "languagePreference": "english"
  }'
```

---

## 📊 Database Queries

### Check Total Programs
```bash
cd /home/user/webapp
npx wrangler d1 execute webapp-production --local --command="SELECT COUNT(*) as total FROM programs"
```

### View All Categories
```bash
npx wrangler d1 execute webapp-production --local --command="SELECT DISTINCT category FROM programs ORDER BY category"
```

### View Engineering Programs
```bash
npx wrangler d1 execute webapp-production --local --command="SELECT name_en, tuition_fee FROM programs WHERE category='Engineering'"
```

### View All Applications
```bash
npx wrangler d1 execute webapp-production --local --command="SELECT * FROM applications ORDER BY created_at DESC LIMIT 10"
```

---

## 🧪 Testing Checklist

### Visual Testing
- [ ] Homepage loads correctly
- [ ] Hero section displays properly
- [ ] Benefits cards are visible
- [ ] Navigation menu works
- [ ] Language selector functions
- [ ] Footer displays correctly
- [ ] Mobile responsive design works

### Functional Testing
- [ ] Language switching works (all 7 languages)
- [ ] Programs page loads 55 programs
- [ ] Category filtering works
- [ ] Application form validates input
- [ ] Application submission saves to database
- [ ] All internal links work
- [ ] API endpoints return correct data

### Content Testing
- [ ] All translations display correctly
- [ ] No broken images or icons
- [ ] All program data is accurate
- [ ] Legal disclaimers are present
- [ ] Contact information is correct

### Performance Testing
- [ ] Page load time < 3 seconds
- [ ] API response time < 500ms
- [ ] No console errors
- [ ] CSS and JS files load properly

---

## 📱 Mobile Testing URLs

Open these URLs on mobile devices:

- **Homepage:** https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/
- **Programs:** https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/programs
- **Application:** https://3000-iypetf6uirysdbu4gaip6-2e1b9533.sandbox.novita.ai/apply

---

## ⚡ Quick Commands

### Restart Server
```bash
cd /home/user/webapp
pm2 restart webapp
```

### View Logs
```bash
pm2 logs webapp --nostream
```

### Check Server Status
```bash
pm2 status
curl http://localhost:3000
```

### Rebuild Application
```bash
cd /home/user/webapp
npm run build
pm2 restart webapp
```

---

**Last Updated:** 2026-02-10  
**Status:** ✅ All Systems Operational
