import { jsxRenderer } from 'hono/jsx-renderer'
import { translations } from './translations'

export const renderer = jsxRenderer(({ children }, c) => {
  const lang = c.req.query('lang') || 'en';
  const currentPath = c.req.path;
  
  // Helper function to get translation
  const tr = translations[lang as keyof typeof translations] || translations.en;
  
  return (
    <html lang={lang}>
      <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <title>EUROSTAR × MALTEPE UNIVERSITY - Official International Master & Residence Platform</title>
        <meta name="description" content="Study 2-3 days a week. Stay legally in Turkey. Official Master's programs in Istanbul with student residence permit." />
        <meta name="keywords" content="Master Turkey, Istanbul University, Student Residence Permit, Study in Turkey, Maltepe University" />
        
        {/* Favicon */}
        <link rel="icon" type="image/x-icon" href="/static/favicon.ico" />
        
        {/* Font Awesome */}
        <link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.0/css/all.min.css" rel="stylesheet" />
        
        {/* Slick Carousel CSS */}
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css" />
        
        {/* Tailwind CSS */}
        <script src="https://cdn.tailwindcss.com"></script>
        
        {/* Custom CSS */}
        <link href="/static/style.css" rel="stylesheet" />
      </head>
      <body>
        {/* Navigation */}
        <nav class="navbar">
          <div class="container">
            <div class="navbar-brand">
              <a href={`/?lang=${lang}`} class="brand-link">
                <span class="brand-eurostar">EUROSTAR</span>
                <span class="brand-separator">×</span>
                <span class="brand-maltepe">MALTEPE</span>
              </a>
            </div>
            
            <div class="navbar-menu" id="navbarMenu">
              <a href={`/?lang=${lang}`} class={currentPath === '/' ? 'active' : ''}>{tr.nav_home}</a>
              <a href={`/why-turkey?lang=${lang}`} class={currentPath === '/why-turkey' ? 'active' : ''}>{tr.nav_why_turkey}</a>
              <a href={`/maltepe?lang=${lang}`} class={currentPath === '/maltepe' ? 'active' : ''}>{tr.nav_maltepe}</a>
              <a href={`/programs?lang=${lang}`} class={currentPath === '/programs' ? 'active' : ''}>{tr.nav_programs}</a>
              <a href={`/living?lang=${lang}`} class={currentPath === '/living' ? 'active' : ''}>{tr.nav_living}</a>
              <a href={`/residence?lang=${lang}`} class={currentPath === '/residence' ? 'active' : ''}>{tr.nav_residence}</a>
              <a href={`/contact?lang=${lang}`} class={currentPath === '/contact' ? 'active' : ''}>{tr.nav_contact}</a>
              <a href={`/apply?lang=${lang}`} class="btn btn-primary">{tr.nav_apply}</a>
            </div>
            
            {/* Language Selector */}
            <div class="language-selector">
              <button class="language-btn" id="langBtn">
                <i class="fas fa-globe"></i> {lang.toUpperCase()}
              </button>
              <div class="language-dropdown" id="langDropdown">
                <a href={`${currentPath}?lang=en`} class={lang === 'en' ? 'active' : ''}>English</a>
                <a href={`${currentPath}?lang=tk`} class={lang === 'tk' ? 'active' : ''}>Türkmençe</a>
                <a href={`${currentPath}?lang=fa`} class={lang === 'fa' ? 'active' : ''}>فارسی</a>
                <a href={`${currentPath}?lang=fr`} class={lang === 'fr' ? 'active' : ''}>Français</a>
                <a href={`${currentPath}?lang=az`} class={lang === 'az' ? 'active' : ''}>Azərbaycan</a>
                <a href={`${currentPath}?lang=kz`} class={lang === 'kz' ? 'active' : ''}>Қазақша</a>
                <a href={`${currentPath}?lang=id`} class={lang === 'id' ? 'active' : ''}>Indonesia</a>
              </div>
            </div>
            
            <button class="mobile-menu-btn" id="mobileMenuBtn">
              <i class="fas fa-bars"></i>
            </button>
          </div>
        </nav>
        
        {/* Main Content */}
        <main>
          {children}
        </main>
        
        {/* WhatsApp Floating Button */}
        <a href="https://wa.me/905433445887" class="whatsapp-float" target="_blank" rel="noopener noreferrer">
          <i class="fab fa-whatsapp"></i>
        </a>
        
        {/* Footer */}
        <footer class="footer">
          <div class="container">
            <div class="footer-grid">
              <div class="footer-col">
                <h3>{tr.footer_about}</h3>
                <p>{tr.footer_about_desc}</p>
              </div>
              
              <div class="footer-col">
                <h3>{tr.footer_quick_links}</h3>
                <ul>
                  <li><a href={`/why-turkey?lang=${lang}`}>{tr.nav_why_turkey}</a></li>
                  <li><a href={`/maltepe?lang=${lang}`}>{tr.nav_maltepe}</a></li>
                  <li><a href={`/programs?lang=${lang}`}>{tr.nav_programs}</a></li>
                  <li><a href={`/residence?lang=${lang}`}>{tr.nav_residence}</a></li>
                </ul>
              </div>
              
              <div class="footer-col">
                <h3>{tr.footer_contact}</h3>
                <p>
                  <i class="fas fa-map-marker-alt"></i> İstiklal Street No:49/5<br/>
                  Taksim, İstanbul, Turkey<br/><br/>
                  <i class="fas fa-phone"></i> <a href="tel:+902122446600">0212 244 66 00</a><br/>
                  <i class="fab fa-whatsapp"></i> <a href="https://wa.me/905433445887" target="_blank">0543 344 58 87</a>
                </p>
              </div>
            </div>
            
            <div class="footer-bottom">
              <p>&copy; 2026 EUROSTAR International Education. {tr.footer_disclaimer}</p>
            </div>
          </div>
        </footer>
        
        {/* Mobile Menu Toggle Script */}
        <script dangerouslySetInnerHTML={{
          __html: `
            // Mobile menu toggle
            document.getElementById('mobileMenuBtn')?.addEventListener('click', function() {
              document.getElementById('navbarMenu')?.classList.toggle('active');
            });
            
            // Language dropdown toggle
            document.getElementById('langBtn')?.addEventListener('click', function() {
              document.getElementById('langDropdown')?.classList.toggle('show');
            });
            
            // Close dropdowns when clicking outside
            document.addEventListener('click', function(e) {
              if (!e.target.closest('.language-selector')) {
                document.getElementById('langDropdown')?.classList.remove('show');
              }
            });
          `
        }} />
      </body>
    </html>
  )
})
