// Multilingual translations for EUROSTAR × MALTEPE UNIVERSITY website
// Languages: EN, TK (Turkmen), FA (Persian), FR (French), AZ (Azerbaijani), KZ (Kazakh), ID (Indonesian)

export const translations = {
  en: {
    // Navigation
    nav_home: "Home",
    nav_why_turkey: "Why Turkey?",
    nav_maltepe: "About Maltepe",
    nav_programs: "Programs",
    nav_study_work: "Study + Work",
    nav_living: "Living in Istanbul",
    nav_residence: "Residence Process",
    nav_contact: "Contact",
    nav_apply: "Apply Now",
    
    // Hero Section
    hero_title: "Turn Your Expiring Residence Into a Future",
    hero_subtitle: "Official Master's programs in Istanbul with legal residence permit",
    hero_cta_apply: "Free Master Application",
    hero_cta_check: "Check Residence Eligibility",
    
    // Key Benefits
    benefits_title: "Your Path to Legal Stay in Turkey",
    benefit_residence_title: "Official Student Residence Permit",
    benefit_residence_desc: "Legal residence permit valid for your study duration, renewable annually",
    benefit_flexible_title: "Study Only 2-3 Days Per Week",
    benefit_flexible_desc: "Flexible schedule allowing you to work and live in Istanbul",
    benefit_work_title: "Work & Earn in Istanbul",
    benefit_work_desc: "Opportunity to work part-time while studying (subject to Turkish law)",
    benefit_diploma_title: "EU-Recognized Diploma",
    benefit_diploma_desc: "Internationally recognized Master's degree with Diploma Supplement",
    
    // Why Master in Turkey
    why_turkey_title: "Why Master's Degree in Turkey?",
    why_legal_title: "Legal Stay Solution",
    why_legal_desc: "Student residence permit is the most sustainable legal option for foreign nationals. Unlike tourist or short-term permits, student residence allows you to stay legally for 2+ years with annual renewal possibility.",
    why_difference_title: "Understanding Residence Types",
    why_difference_desc: "Tourist permits expire in 90 days. Short-term work permits are temporary. Student residence permit provides stable, long-term legal status while you advance your education.",
    why_sustainable_title: "Most Sustainable Option",
    why_sustainable_desc: "Master's programs offer the perfect balance: legal residence, flexible study schedule, and opportunity to work part-time. This is not a shortcut - it's a legitimate path to building your future in Turkey.",
    
    // About Maltepe
    maltepe_title: "About Maltepe University",
    maltepe_desc: "Founded in 1997, Maltepe University is a leading private university in Istanbul, Turkey. Located in the Marmara Education Village, the campus offers a green, safe, and modern learning environment.",
    maltepe_campus_title: "Modern Campus in Istanbul",
    maltepe_campus_desc: "Green campus with modern facilities, sports centers, library, and student housing in Maltepe district",
    maltepe_international_title: "International Environment",
    maltepe_international_desc: "Students from over 50 countries, English-taught programs, Erasmus+ partnerships",
    maltepe_accreditation_title: "EU Diploma Supplement",
    maltepe_accreditation_desc: "Internationally recognized degrees with official EU Diploma Supplement",
    
    // Programs
    programs_title: "Master's Programs",
    programs_subtitle: "Choose from 55+ graduate programs across various fields",
    programs_filter_all: "All Programs",
    programs_filter_engineering: "Engineering",
    programs_filter_business: "Business",
    programs_filter_law: "Law",
    programs_filter_architecture: "Architecture & Design",
    programs_filter_education: "Education",
    programs_filter_psychology: "Psychology",
    programs_filter_media: "Media & Communication",
    programs_filter_social: "Social Sciences",
    programs_filter_political: "Political Science",
    programs_filter_arts: "Arts",
    programs_thesis: "With Thesis",
    programs_non_thesis: "Non-Thesis",
    programs_tuition: "Tuition Fee",
    programs_language: "Language",
    programs_duration: "Duration",
    programs_attendance: "Attendance",
    
    // Study + Work Model
    study_work_title: "Study + Work Model",
    study_work_subtitle: "Balance your education with work opportunities in Istanbul",
    study_work_schedule_title: "Weekly Schedule",
    study_work_schedule_desc: "Master's programs require physical attendance only 2-3 days per week. This flexible schedule allows you to:",
    study_work_point1: "Work part-time (subject to Turkish labor law)",
    study_work_point2: "Gain practical experience in your field",
    study_work_point3: "Support yourself financially",
    study_work_point4: "Build professional network in Istanbul",
    study_work_disclaimer: "Legal Disclaimer: Work permits are subject to Turkish law. EUROSTAR provides guidance but cannot guarantee employment. Students must comply with all labor regulations.",
    
    // Living in Istanbul - Maltepe
    living_title: "Living in Istanbul - Maltepe",
    living_subtitle: "Affordable, safe, and student-friendly environment",
    living_costs_title: "Monthly Living Costs",
    living_accommodation: "Accommodation (shared apartment)",
    living_food: "Food & Groceries",
    living_transport: "Transportation (monthly pass)",
    living_personal: "Personal Expenses",
    living_total: "Estimated Total",
    living_transport_title: "Public Transportation",
    living_transport_desc: "Maltepe is well-connected via metro, metrobus, and ferry. Student discount cards available.",
    living_environment_title: "Student-Friendly Environment",
    living_environment_desc: "Safe neighborhood, close to campus, shopping centers, cafes, and entertainment",
    
    // Residence Permit Process
    residence_title: "Student Residence Permit Process",
    residence_subtitle: "Step-by-step guide to obtaining your legal residence",
    residence_step1_title: "Step 1: Free Application",
    residence_step1_desc: "Submit your application through our website - no application fee",
    residence_step2_title: "Step 2: Academic Evaluation",
    residence_step2_desc: "Our team evaluates your qualifications (usually 3-5 business days)",
    residence_step3_title: "Step 3: Acceptance Letter",
    residence_step3_desc: "Receive official acceptance letter from Maltepe University",
    residence_step4_title: "Step 4: Student Certificate",
    residence_step4_desc: "Upon registration, receive student certificate (öğrenci belgesi)",
    residence_step5_title: "Step 5: Residence Application",
    residence_step5_desc: "Apply for student residence permit at local immigration office with our guidance",
    residence_step6_title: "Step 6: Annual Renewal",
    residence_step6_desc: "Renew your residence permit annually while enrolled in program",
    residence_legal_note: "All residence procedures comply with Turkish immigration law. EUROSTAR provides guidance throughout the process.",
    
    // Application Form
    apply_title: "Apply Now - Free Application",
    apply_subtitle: "No application fee for pre-registration evaluation",
    apply_personal_info: "Personal Information",
    apply_full_name: "Full Name",
    apply_email: "Email Address",
    apply_phone: "Phone Number (optional)",
    apply_nationality: "Nationality",
    apply_residence_info: "Current Residence Status",
    apply_residence_status: "Current Residence Type",
    apply_residence_tourist: "Tourist Visa",
    apply_residence_work: "Work Permit",
    apply_residence_family: "Family Residence",
    apply_residence_student: "Student Residence",
    apply_residence_other: "Other",
    apply_expiry_date: "Residence Expiry Date (if applicable)",
    apply_education_info: "Education Background",
    apply_education_level: "Highest Education Level",
    apply_bachelor: "Bachelor's Degree",
    apply_bachelor_university: "University Name",
    apply_bachelor_field: "Field of Study",
    apply_graduation_year: "Graduation Year",
    apply_program_preference: "Program Preferences",
    apply_program_interest: "Field of Interest",
    apply_language_preference: "Preferred Language of Instruction",
    apply_turkish: "Turkish",
    apply_english: "English",
    apply_message: "Additional Message (optional)",
    apply_documents: "Documents (optional)",
    apply_documents_desc: "You can upload documents now or later. Accepted formats: PDF, JPG, PNG",
    apply_submit: "Submit Application",
    apply_privacy: "Your data is protected and used only for application processing",
    
    // Contact Page
    contact_title: "Contact EUROSTAR",
    contact_subtitle: "Get in touch with us for any questions about Master's programs and residence permits",
    contact_office_title: "Our Office",
    contact_office_address: "Address",
    contact_office_phone: "Phone",
    contact_office_whatsapp: "WhatsApp",
    contact_office_email: "Email",
    contact_office_hours: "Office Hours",
    contact_hours_weekday: "Monday - Friday: 9:00 - 18:00",
    contact_hours_saturday: "Saturday: 10:00 - 15:00",
    contact_hours_sunday: "Sunday: Closed",
    contact_form_title: "Send Us a Message",
    contact_form_name: "Your Name",
    contact_form_email: "Your Email",
    contact_form_subject: "Subject",
    contact_form_message: "Message",
    contact_form_send: "Send Message",
    contact_map_title: "Find Us on Map",
    
    // Footer
    footer_about: "About EUROSTAR",
    footer_about_desc: "Official representative for Maltepe University international student admissions",
    footer_contact: "Contact Us",
    footer_quick_links: "Quick Links",
    footer_legal: "Legal & Compliance",
    footer_privacy: "Privacy Policy",
    footer_terms: "Terms of Service",
    footer_disclaimer: "Disclaimer: All information provided is accurate as of publication date. EUROSTAR and Maltepe University reserve the right to modify programs and requirements.",
    
    // Common
    learn_more: "Learn More",
    read_more: "Read More",
    back: "Back",
    next: "Next",
    loading: "Loading...",
    error: "An error occurred",
    success: "Success",
    close: "Close",
    or: "or",
    per_year: "per year",
    years: "years",
  },
  
  tk: {
    // Turkmen translations
    nav_home: "Baş sahypa",
    nav_why_turkey: "Näme üçin Türkiýe?",
    nav_maltepe: "Maltepe hakda",
    nav_programs: "Programmalar",
    nav_study_work: "Okamak + Işlemek",
    nav_living: "Stambulda ýaşamak",
    nav_residence: "Rezidentlik prosesi",
    nav_contact: "Habarlaşmak",
    nav_apply: "Ýüz tutmak",
    
    hero_title: "Möhletiniň Gutarýan Rezidentligini Geljege Öwür",
    hero_subtitle: "Stambulda resmi rezidentlik rugsady bilen Magistratura programmalary",
    hero_cta_apply: "Mugt Magistratura Arzasy",
    hero_cta_check: "Rezidentlik Eligiňizi Barlaň",
    
    benefits_title: "Türkiýede Kanuny Ýaşamagyň Ýoly",
    benefit_residence_title: "Resmi Talyp Rezidentlik Rugsady",
    benefit_residence_desc: "Okuw döwri üçin ygtybarlylygy bar kanuny rezidentlik rugsady, her ýyl täzelenýär",
    benefit_flexible_title: "Diňe Hepdede 2-3 Gün Okuň",
    benefit_flexible_desc: "Stambulda işlemäge we ýaşamaga mümkinçilik berýän çeýe tertip",
    benefit_work_title: "Stambulda Işläň we Gazanç Ediň",
    benefit_work_desc: "Okamak bilen birlikde ýarym günlük işlemek mümkinçiligi (Türk kanunyna laýyklykda)",
    benefit_diploma_title: "EUB Tarapyndan Ykrar Edilen Diploma",
    benefit_diploma_desc: "Diploma Goşmaçasy bilen halkara derejesinde ykrar edilen Magistr derejesi",
    
    why_turkey_title: "Näme üçin Türkiýede Magistratura?",
    why_legal_title: "Kanuny Ýaşamagyň Çözgüdi",
    why_legal_desc: "Talyp rezidentlik rugsady daşary ýurtly raýatlar üçin iň durnukly kanuny wariant. Syýahatçylyk ýa-da gysga möhletli rugsatlardan tapawutlylykda, talyp rezidentligi ýylda täzelenmek mümkinçiligi bilen 2+ ýyl kanuny ýaşamaga mümkinçilik berýär.",
    
    programs_title: "Magistratura Programmalary",
    programs_subtitle: "Dürli ugurlar boýunça 55+ aspirantura programmasyndan saýlaň",
    programs_filter_all: "Ähli Programmalar",
    
    apply_title: "Indi Ýüz Tutuň - Mugt Arza",
    apply_subtitle: "Deslapky hasaba alyş üçin arza üçin töleg ýok",
    apply_full_name: "Doly Ady",
    apply_email: "E-poçta Salgysy",
    apply_submit: "Arzany Ugrat",
    
    footer_about: "EUROSTAR hakda",
    footer_contact: "Biz bilen habarlaşyň",
  },
  
  fa: {
    // Persian (Farsi) translations
    nav_home: "صفحه اصلی",
    nav_why_turkey: "چرا ترکیه؟",
    nav_maltepe: "درباره مالتپه",
    nav_programs: "برنامه‌ها",
    nav_study_work: "تحصیل + کار",
    nav_living: "زندگی در استانبول",
    nav_residence: "فرآیند اقامت",
    nav_contact: "تماس",
    nav_apply: "ثبت‌نام",
    
    hero_title: "اقامت در حال انقضای خود را به آینده تبدیل کنید",
    hero_subtitle: "برنامه‌های رسمی کارشناسی ارشد در استانبول با مجوز اقامت قانونی",
    hero_cta_apply: "درخواست رایگان کارشناسی ارشد",
    hero_cta_check: "بررسی واجد شرایط بودن اقامت",
    
    benefits_title: "مسیر شما به اقامت قانونی در ترکیه",
    benefit_residence_title: "مجوز اقامت رسمی دانشجویی",
    benefit_residence_desc: "مجوز اقامت قانونی معتبر برای مدت تحصیل، قابل تمدید سالانه",
    benefit_flexible_title: "فقط 2-3 روز در هفته درس",
    benefit_flexible_desc: "برنامه انعطاف‌پذیر که به شما امکان کار و زندگی در استانبول را می‌دهد",
    benefit_work_title: "کار و درآمد در استانبول",
    benefit_work_desc: "فرصت کار پاره‌وقت در حین تحصیل (مشمول قوانین کار ترکیه)",
    benefit_diploma_title: "مدرک معتبر اتحادیه اروپا",
    benefit_diploma_desc: "مدرک کارشناسی ارشد معتبر بین‌المللی با مکمل دیپلم",
    
    why_turkey_title: "چرا کارشناسی ارشد در ترکیه؟",
    why_legal_title: "راه‌حل اقامت قانونی",
    why_legal_desc: "مجوز اقامت دانشجویی پایدارترین گزینه قانونی برای اتباع خارجی است. برخلاف مجوزهای توریستی یا کوتاه‌مدت، اقامت دانشجویی به شما امکان اقامت قانونی 2+ ساله با قابلیت تمدید سالانه را می‌دهد.",
    
    programs_title: "برنامه‌های کارشناسی ارشد",
    programs_subtitle: "از بیش از 55 برنامه تحصیلات تکمیلی در زمینه‌های مختلف انتخاب کنید",
    programs_filter_all: "همه برنامه‌ها",
    
    apply_title: "اکنون درخواست دهید - درخواست رایگان",
    apply_subtitle: "بدون هزینه درخواست برای ارزیابی پیش‌ثبت‌نام",
    apply_full_name: "نام کامل",
    apply_email: "آدرس ایمیل",
    apply_submit: "ارسال درخواست",
    
    footer_about: "درباره یوراستار",
    footer_contact: "تماس با ما",
  },
  
  fr: {
    // French translations
    nav_home: "Accueil",
    nav_why_turkey: "Pourquoi la Turquie?",
    nav_maltepe: "À propos de Maltepe",
    nav_programs: "Programmes",
    nav_study_work: "Étudier + Travailler",
    nav_living: "Vivre à Istanbul",
    nav_residence: "Processus de résidence",
    nav_contact: "Contact",
    nav_apply: "Postuler",
    
    hero_title: "Transformez Votre Résidence Expirante en Avenir",
    hero_subtitle: "Programmes officiels de Master à Istanbul avec permis de résidence légal",
    hero_cta_apply: "Candidature Gratuite au Master",
    hero_cta_check: "Vérifier l'Éligibilité à la Résidence",
    
    benefits_title: "Votre Chemin vers un Séjour Légal en Turquie",
    benefit_residence_title: "Permis de Résidence Étudiant Officiel",
    benefit_residence_desc: "Permis de résidence légal valable pour la durée de vos études, renouvelable annuellement",
    benefit_flexible_title: "Étudiez Seulement 2-3 Jours par Semaine",
    benefit_flexible_desc: "Emploi du temps flexible vous permettant de travailler et vivre à Istanbul",
    benefit_work_title: "Travailler et Gagner à Istanbul",
    benefit_work_desc: "Possibilité de travailler à temps partiel en étudiant (selon la loi turque)",
    benefit_diploma_title: "Diplôme Reconnu par l'UE",
    benefit_diploma_desc: "Diplôme de Master reconnu internationalement avec Supplément au Diplôme",
    
    why_turkey_title: "Pourquoi un Master en Turquie?",
    why_legal_title: "Solution de Séjour Légal",
    why_legal_desc: "Le permis de résidence étudiant est l'option légale la plus durable pour les ressortissants étrangers. Contrairement aux permis touristiques ou de courte durée, la résidence étudiante vous permet de rester légalement pendant 2+ ans avec possibilité de renouvellement annuel.",
    
    programs_title: "Programmes de Master",
    programs_subtitle: "Choisissez parmi plus de 55 programmes d'études supérieures dans divers domaines",
    programs_filter_all: "Tous les Programmes",
    
    apply_title: "Postuler Maintenant - Candidature Gratuite",
    apply_subtitle: "Pas de frais de candidature pour l'évaluation de pré-inscription",
    apply_full_name: "Nom Complet",
    apply_email: "Adresse E-mail",
    apply_submit: "Soumettre la Candidature",
    
    footer_about: "À propos d'EUROSTAR",
    footer_contact: "Nous Contacter",
  },
  
  az: {
    // Azerbaijani translations
    nav_home: "Ana səhifə",
    nav_why_turkey: "Niyə Türkiyə?",
    nav_maltepe: "Maltepe haqqında",
    nav_programs: "Proqramlar",
    nav_study_work: "Təhsil + İş",
    nav_living: "İstanbulda yaşamaq",
    nav_residence: "İqamət prosesi",
    nav_contact: "Əlaqə",
    nav_apply: "Müraciət et",
    
    hero_title: "Bitən İqamətinizi Gələcəyə Çevirin",
    hero_subtitle: "İstanbulda qanuni iqamət icazəsi ilə rəsmi Magistr proqramları",
    hero_cta_apply: "Pulsuz Magistr Müraciəti",
    hero_cta_check: "İqamət Uyğunluğunu Yoxlayın",
    
    benefits_title: "Türkiyədə Qanuni Yaşamağa Yolunuz",
    benefit_residence_title: "Rəsmi Tələbə İqamət İcazəsi",
    benefit_residence_desc: "Təhsil müddətiniz üçün etibarlı qanuni iqamət icazəsi, hər il yenilənə bilər",
    benefit_flexible_title: "Həftədə Yalnız 2-3 Gün Oxuyun",
    benefit_flexible_desc: "İstanbulda işləməyə və yaşamağa imkan verən çevik cədvəl",
    benefit_work_title: "İstanbulda İşləyin və Qazanın",
    benefit_work_desc: "Təhsil aldığınız müddətdə part-time işləmək imkanı (Türk qanunlarına uyğun olaraq)",
    benefit_diploma_title: "AB Tərəfindən Tanınan Diplom",
    benefit_diploma_desc: "Diplom Əlavəsi ilə beynəlxalq səviyyədə tanınan Magistr dərəcəsi",
    
    why_turkey_title: "Niyə Türkiyədə Magistr?",
    why_legal_title: "Qanuni Yaşayış Həlli",
    why_legal_desc: "Tələbə iqamət icazəsi xarici vətəndaşlar üçün ən davamlı qanuni variantdır. Turist və ya qısamüddətli icazələrdən fərqli olaraq, tələbə iqaməti hər il yenilənmə imkanı ilə 2+ il qanuni qalmağa imkan verir.",
    
    programs_title: "Magistr Proqramları",
    programs_subtitle: "Müxtəlif sahələrdə 55+ aspirantura proqramından seçin",
    programs_filter_all: "Bütün Proqramlar",
    
    apply_title: "İndi Müraciət Edin - Pulsuz Müraciət",
    apply_subtitle: "İlkin qeydiyyat qiymətləndirilməsi üçün müraciət haqqı yoxdur",
    apply_full_name: "Tam Ad",
    apply_email: "E-poçt Ünvanı",
    apply_submit: "Müraciət Göndər",
    
    footer_about: "EUROSTAR haqqında",
    footer_contact: "Bizimlə əlaqə",
  },
  
  kz: {
    // Kazakh translations
    nav_home: "Басты бет",
    nav_why_turkey: "Неге Түркия?",
    nav_maltepe: "Малтепе туралы",
    nav_programs: "Бағдарламалар",
    nav_study_work: "Оқу + Жұмыс",
    nav_living: "Стамбулда өмір сүру",
    nav_residence: "Тұрғылықты рәсімдеу",
    nav_contact: "Байланыс",
    nav_apply: "Өтініш беру",
    
    hero_title: "Мерзімі Өтіп Бара Жатқан Тұрғылықтыңызды Болашаққа Айналдырыңыз",
    hero_subtitle: "Стамбулда заңды тұрғылықты рұқсатпен ресми Магистратура бағдарламалары",
    hero_cta_apply: "Тегін Магистратураға Өтініш",
    hero_cta_check: "Тұрғылықты Сәйкестігін Тексеру",
    
    benefits_title: "Түркияда Заңды Өмір Сүруге Жол",
    benefit_residence_title: "Ресми Студенттік Тұрғылықты Рұқсат",
    benefit_residence_desc: "Оқу мерзіміңіз үшін жарамды заңды тұрғылықты рұқсат, жыл сайын жаңартылады",
    benefit_flexible_title: "Аптасына Тек 2-3 Күн Оқыңыз",
    benefit_flexible_desc: "Стамбулда жұмыс істеуге және өмір сүруге мүмкіндік беретін икемді кесте",
    benefit_work_title: "Стамбулда Жұмыс Істеңіз және Табыс Табыңыз",
    benefit_work_desc: "Оқу кезінде жартылай күн жұмыс істеу мүмкіндігі (Түркия заңына сәйкес)",
    benefit_diploma_title: "ЕО Мойындаған Диплом",
    benefit_diploma_desc: "Диплом Қосымшасымен халықаралық деңгейде танылған Магистр дәрежесі",
    
    why_turkey_title: "Неге Түркияда Магистратура?",
    why_legal_title: "Заңды Тұру Шешімі",
    why_legal_desc: "Студенттік тұрғылықты рұқсат шетелдік азаматтар үшін ең тұрақты заңды нұсқа. Туристік немесе қысқа мерзімді рұқсаттардан айырмашылығы, студенттік тұрғылықты жыл сайын жаңарту мүмкіндігімен 2+ жыл заңды тұруға мүмкіндік береді.",
    
    programs_title: "Магистратура Бағдарламалары",
    programs_subtitle: "Әртүрлі салалар бойынша 55+ аспирантура бағдарламасынан таңдаңыз",
    programs_filter_all: "Барлық Бағдарламалар",
    
    apply_title: "Қазір Өтініш Беріңіз - Тегін Өтініш",
    apply_subtitle: "Алдын ала тіркелуді бағалау үшін өтініш төлемі жоқ",
    apply_full_name: "Толық Аты",
    apply_email: "Электрондық Пошта Мекенжайы",
    apply_submit: "Өтінішті Жіберу",
    
    footer_about: "EUROSTAR туралы",
    footer_contact: "Бізбен байланысу",
  },
  
  id: {
    // Indonesian translations
    nav_home: "Beranda",
    nav_why_turkey: "Mengapa Turki?",
    nav_maltepe: "Tentang Maltepe",
    nav_programs: "Program",
    nav_study_work: "Kuliah + Kerja",
    nav_living: "Tinggal di Istanbul",
    nav_residence: "Proses Izin Tinggal",
    nav_contact: "Kontak",
    nav_apply: "Daftar Sekarang",
    
    hero_title: "Ubah Izin Tinggal Anda yang Hampir Habis Menjadi Masa Depan",
    hero_subtitle: "Program Master resmi di Istanbul dengan izin tinggal legal",
    hero_cta_apply: "Pendaftaran Master Gratis",
    hero_cta_check: "Cek Kelayakan Izin Tinggal",
    
    benefits_title: "Jalur Anda untuk Tinggal Legal di Turki",
    benefit_residence_title: "Izin Tinggal Mahasiswa Resmi",
    benefit_residence_desc: "Izin tinggal legal yang berlaku selama masa studi Anda, dapat diperpanjang setiap tahun",
    benefit_flexible_title: "Kuliah Hanya 2-3 Hari Per Minggu",
    benefit_flexible_desc: "Jadwal fleksibel yang memungkinkan Anda bekerja dan tinggal di Istanbul",
    benefit_work_title: "Bekerja & Menghasilkan di Istanbul",
    benefit_work_desc: "Kesempatan bekerja paruh waktu sambil kuliah (sesuai hukum Turki)",
    benefit_diploma_title: "Diploma Diakui UE",
    benefit_diploma_desc: "Gelar Master yang diakui secara internasional dengan Suplemen Diploma",
    
    why_turkey_title: "Mengapa Gelar Master di Turki?",
    why_legal_title: "Solusi Tinggal Legal",
    why_legal_desc: "Izin tinggal mahasiswa adalah opsi legal yang paling berkelanjutan untuk warga negara asing. Tidak seperti izin turis atau jangka pendek, izin tinggal mahasiswa memungkinkan Anda tinggal secara legal selama 2+ tahun dengan kemungkinan perpanjangan tahunan.",
    
    programs_title: "Program Magister",
    programs_subtitle: "Pilih dari 55+ program pascasarjana di berbagai bidang",
    programs_filter_all: "Semua Program",
    
    apply_title: "Daftar Sekarang - Pendaftaran Gratis",
    apply_subtitle: "Tidak ada biaya pendaftaran untuk evaluasi pra-registrasi",
    apply_full_name: "Nama Lengkap",
    apply_email: "Alamat Email",
    apply_submit: "Kirim Pendaftaran",
    
    footer_about: "Tentang EUROSTAR",
    footer_contact: "Hubungi Kami",
  }
};

export type Language = keyof typeof translations;
export type TranslationKey = keyof typeof translations.en;

export function getTranslation(lang: Language, key: TranslationKey): string {
  return translations[lang]?.[key] || translations.en[key] || key;
}
